CREATE TABLE ram_route
(
    sid          BIGINT(20)   NOT NULL,
    app          VARCHAR(40)  NULL DEFAULT NULL COMMENT '应用ID',
    method       VARCHAR(10)  NULL DEFAULT NULL COMMENT '方法',
    path         VARCHAR(200) NOT NULL COMMENT '路径' COLLATE 'utf8_bin',
    create_by    BIGINT(20)   NULL DEFAULT '0' COMMENT '创建人',
    create_by_id VARCHAR(255) NULL DEFAULT NULL COMMENT '创建人',
    create_date  DATETIME     NULL DEFAULT NULL COMMENT '创建日期',
    modify_by    BIGINT(20)   NULL DEFAULT '0' COMMENT '修改人',
    modify_by_id VARCHAR(255) NULL DEFAULT NULL COMMENT '修改人',
    modify_date  DATETIME     NULL DEFAULT NULL COMMENT '修改日期',
    deleted      BIT(1)            DEFAULT b'0',
    PRIMARY KEY (sid) USING BTREE,
    UNIQUE INDEX uk_app_method_path (app, method, path) USING BTREE
);
