/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.access.TargetTypeChain;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

@Order(value=200)
public class AllowListPolicyFilterHandler
extends PolicyFilterHandler {
    public AllowListPolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        PatternVO matched;
        MappingRegistry mappingRegistry = this.ramCoreService.getPattern(request.getAppId(), PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry)) != null) {
            ResultType resultType = TargetTypeChain.getInstance(this, TargetInfo.getTargets(context)).matches(request);
            return resultType == ResultType.ALLOW ? ResultType.ALLOW : ResultType.EXPLICIT_DENY;
        }
        return ResultType.IMPLICIT_DENY;
    }

    @Override
    public ResultType matches(String targetType, String targetId, RequestInfo request) {
        PatternVO matched;
        Statement statement = this.ramCoreService.getPolicyRoute(request.getAppId(), PolicyType.AllowList.name(), targetType, targetId);
        if (!statement.getAllow().isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow())) != null) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}

