/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamRouteCrudServiceImpl
implements RamRouteCrudService {
    @Autowired
    private RamRouteMapper ramRouteMapper;

    @Override
    public long insert(Route data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(Route data) {
        BaseUtils.setCreateFields(data);
        this.ramRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public Route findBySid(long sid) {
        return this.ramRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Route data) {
        return this.ramRouteMapper.existsBySid(data.getSid());
    }

    @Override
    public PageData<RouteVO> findByPage(Page<Route> page) {
        Filter<Route> filter = page.filter();
        long total = this.ramRouteMapper.countByPage(filter.getEq(), filter);
        if (total == 0L) {
            return PageData.empty();
        }
        List<RouteVO> paths = this.ramRouteMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }

    @Override
    public List<Route> findByCond(Route data) {
        return this.ramRouteMapper.findByCond(data);
    }
}

