package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

/**
 * 全局不参与，特殊策略类型
 * <p>
 * 针对一些特殊的访问量高且不需要管控的API，如登录、Token解析等
 * <ol>
 *     <li>减少不必要的白名单配置</li>
 *     <li>优化效率，减少缓存查询和比较</li>
 * </ol>
 *
 * @author fobgochod
 * @date 2023/3/15 9:33
 */
@Order(0)
public class BeforePolicyFilterHandler extends PolicyFilterHandler {

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        if (MatcherUtils.policyAllows().get(request.getPath()) != null) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}
