package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantCrudServiceImpl implements RamGrantCrudService {

    @Autowired
    private RamGrantMapper ramGrantMapper;

    @Override
    public long insert(Grant data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramGrantMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setCreateFields(data);
        ramGrantMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return ramGrantMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Grant data) {
        return ramGrantMapper.exists(data.getSid());
    }

    @Override
    public List<Grant> findByCond(Grant data) {
        return ramGrantMapper.findByCond(data);
    }

    @Override
    public PageData<GrantVO> findByPage(Page<Grant> page) {
        Filter<Grant> filter = page.filter();
        long total = ramGrantMapper.countByPage(filter.getEq(), filter);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantVO> paths = ramGrantMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }
}
