package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.constant.CacheConstant;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.cache.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RamCacheServiceImpl implements RamCacheService {

    @Value("${spring.application.name:dap}")
    private String appName;

    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;

    @Override
    public void grantRemove(Grant grant) {
        if (grant == null) {
            return;
        }
        RedisUtils.delete(CacheConstant.getGrantTarget(appName, grant.getApp(), grant.getType(), grant.getTargetId()));
    }

    @Override
    public void grantPolicyChange(long grantSid) {
        Grant grant = ramGrantCrudService.findBySid(grantSid);
        this.grantRemove(grant);
    }

    @Override
    public void policyRemove(Policy policy) {
        if (policy == null) {
            return;
        }
        if (PolicyType.isSole(policy.getType())) {
            RedisUtils.delete(CacheConstant.getPolicyType(appName, policy.getApp(), policy.getType()));
        } else if (PolicyType.AllowList.name().equals(policy.getType())) {
            RedisUtils.delete(CacheConstant.getPolicyType(appName, policy.getApp(), policy.getType()));
        } else {
            RedisUtils.delete(CacheConstant.getPolicyId(appName, policy.getApp(), policy.getId()));
        }
    }

    @Override
    public void policyRouteChange(long policySid, long routeSid) {
        Policy policy = ramPolicyCrudService.findBySid(policySid);
        Route route = ramRouteCrudService.findBySid(routeSid);
        if (policy == null || route == null) {
            return;
        }
        if (PolicyType.isSole(policy.getType())) {
            RedisUtils.delete(CacheConstant.getPolicyType(appName, policy.getApp(), policy.getType()));
        } else if (PolicyType.AllowList.name().equals(policy.getType())) {
            RedisUtils.delete(CacheConstant.getPolicyType(appName, policy.getApp(), policy.getType()));
        } else if (PolicyType.Function.name().equals(policy.getType())) {
            RedisUtils.delete(CacheConstant.getPolicyPath(appName, policy.getApp(), route.getMethod(), route.getPath()));
        }
        RedisUtils.delete(CacheConstant.getPolicyId(appName, policy.getApp(), policy.getId()));
    }

    @Override
    public void routeChange(String appId) {
        RedisUtils.delete(CacheConstant.getRouteApp(appName, appId));
    }
}
