package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;

import java.util.List;

public interface GrantExecutor {

    /**
     * 获取目标配置的所有策略ID
     * <p>
     * 支持策略类型 {@link PolicyType#Base} {@link PolicyType#AllowList}
     *
     * @param app        应用ID
     * @param targetType 目标类型 {@link TargetType}
     * @param targetId   目标ID
     */
    List<PolicyVO> findPolicyIdByTarget(String app, String targetType, String targetId);
}

