/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.entity.Route;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class PatternVO {
    private String method;
    private String path;
    private String tableName;
    private Boolean effect;

    public PatternVO() {
    }

    public PatternVO(Route route) {
        this.method = route.getMethod();
        this.path = route.getPath();
        this.tableName = route.getTableName();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getEffect() {
        return this.effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    public String path() {
        return StringUtils.hasLength((String)this.tableName) ? this.path + "/" + this.tableName : this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternVO patternVO = (PatternVO)o;
        return Objects.equals(this.method, patternVO.method) && this.path.equals(patternVO.path) && Objects.equals(this.tableName, patternVO.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.tableName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StringUtils.hasLength((String)this.method)) {
            builder.append(this.method);
        }
        builder.append("-").append(this.path);
        if (StringUtils.hasLength((String)this.tableName)) {
            builder.append("/").append(this.tableName);
        }
        builder.append("}");
        return builder.toString();
    }
}

