/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.access.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class BeforeAuthenticationFilter
extends OncePerRequestFilter
implements Ordered {
    private final List<PolicyFilterHandler> policyHandlers;

    public BeforeAuthenticationFilter(List<PolicyFilterHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        AppAuthContext context = AppAuthContextHolder.getContext();
        try {
            PolicyTypeChain policyTypeChain = new PolicyTypeChain(this.policyHandlers);
            ResultType result = policyTypeChain.doNextStep(context, context.getRequestInfo());
            context.setResultType(result.name());
        }
        catch (Exception e) {
            this.logger.error((Object)"RAM before authentication filter handler error", (Throwable)e);
        }
        if (ResultType.EXPLICIT_DENY.name().equals(context.getResultType())) {
            throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public int getOrder() {
        return FilterOrderEnum.BEFORE_SECURITY.order();
    }
}

