/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.authentication.handler;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=15)
public class NoAuthAppAuthCheckHandler
extends AuthCheckHandler {
    public NoAuthAppAuthCheckHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNone;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        List<String> policyIds = this.ramCoreService.findPolicyId(request.getAppId(), PolicyType.NoAuthApp.name(), TargetType.Sys.name(), sys.getId());
        if (!policyIds.isEmpty()) {
            if (policyIds.contains(PolicyType.NoAuthApp.name())) {
                authResult.setAuthType(AuthType.AppOk);
            } else {
                Statement statement = this.ramCoreService.getPolicyRoute(request.getAppId(), policyIds);
                PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
                if (matched != null) {
                    authResult.setAuthType(AuthType.AppOk);
                }
            }
        }
        return authResult;
    }
}

