/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.condition.MappingInfo;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherUtils {
    private static final Logger logger = LoggerFactory.getLogger(MatcherUtils.class);

    public static Map<String, Boolean> policyAllows() {
        HashMap<String, Boolean> allowPath = new HashMap<String, Boolean>(6);
        allowPath.put("/api/iam/v2/identity/login", Boolean.TRUE);
        allowPath.put("/api/iam/v2/identity/login/internal", Boolean.TRUE);
        allowPath.put("/api/iam/v2/identity/token/analyze", Boolean.TRUE);
        allowPath.put("/api/iam/v2/identity/token/analyze/internal", Boolean.TRUE);
        allowPath.put("/api/ram/v2/access/srv/user/analyze", Boolean.TRUE);
        allowPath.put("/api/ram/v2/access/srv/tenant/analyze", Boolean.TRUE);
        return allowPath;
    }

    public static Map<String, Boolean> authAllows() {
        HashMap<String, Boolean> allowPath = new HashMap<String, Boolean>(4);
        allowPath.put("/api/iam/v2/identity/login", Boolean.TRUE);
        allowPath.put("/api/iam/v2/identity/login/internal", Boolean.TRUE);
        allowPath.put("/api/ram/v2/access/srv/user/analyze", Boolean.TRUE);
        allowPath.put("/api/ram/v2/access/srv/tenant/analyze", Boolean.TRUE);
        return allowPath;
    }

    public static boolean matches(HttpServletRequest request, MappingRegistry mappingRegistry) {
        MappingInfo match;
        String lookupPath = mappingRegistry.getUrlPathHelper().getLookupPathForRequest(request);
        List<MappingInfo> directPathMatches = mappingRegistry.getMappingsByUrl(lookupPath);
        if (directPathMatches != null) {
            for (MappingInfo mapping : directPathMatches) {
                match = mapping.getMatchingCondition(request);
                if (match == null) continue;
                logger.debug("matched " + mapping);
                return true;
            }
        }
        for (MappingInfo mapping : mappingRegistry.getMappingLookup().keySet()) {
            match = mapping.getMatchingCondition(request);
            if (match == null) continue;
            logger.debug("matched " + mapping);
            return true;
        }
        logger.debug("No matches found");
        return false;
    }

    public static PatternVO matches(String method, String lookupPath, MappingRegistry mappingRegistry) {
        MappingInfo match;
        List<MappingInfo> directPathMatches = mappingRegistry.getMappingsByUrl(lookupPath);
        if (directPathMatches != null) {
            for (MappingInfo mapping : directPathMatches) {
                match = mapping.getMatchingCondition(method, lookupPath);
                if (match == null) continue;
                logger.debug("matched " + mapping);
                return mappingRegistry.getRegistry().get(match);
            }
        }
        for (MappingInfo mapping : mappingRegistry.getMappingLookup().keySet()) {
            match = mapping.getMatchingCondition(method, lookupPath);
            if (match == null) continue;
            logger.debug("matched " + mapping);
            return mappingRegistry.getMappingLookup().get(match);
        }
        logger.debug("No matches found");
        return null;
    }
}

