/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/pr"})
@RestController
public class RamPolicyRouteController {
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody PolicyRoute body) {
        long sid = this.ramPolicyRouteCrudService.insert(body);
        this.ramCacheService.policyRouteChange(body.getPolicySid(), body.getRouteSid());
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        PolicyRoute policyRoute = (PolicyRoute)this.ramPolicyRouteCrudService.findBySid(body.getSid());
        if (policyRoute == null) {
            return StdData.ofSuccess((Object)BaseSid.ok(0L));
        }
        this.ramPolicyRouteCrudService.deleteBySid(body.getSid());
        this.ramCacheService.policyRouteChange(policyRoute.getPolicySid(), policyRoute.getRouteSid());
        return StdData.ofSuccess((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/find/policy"})
    public StdData<?> getPolicy(@RequestBody PolicyRoute body) {
        List<PolicyVO> policies = this.ramPolicyRouteCrudService.findByRouteSid(body.getRouteSid());
        return StdData.ofSuccess(policies);
    }

    @PostMapping(value={"/find/route"})
    public StdData<?> getRoute(@RequestBody PolicyRoute body) {
        List<RouteVO> routes = this.ramPolicyRouteCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ofSuccess(routes);
    }
}

