/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.condition.MappingInfo;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MappingInfoRegistry
implements InitializingBean {
    private final MappingRegistry internalMappingRegistry = new MappingRegistry();
    private final Map<String, MappingRegistry> appMappingRegistries = new ConcurrentHashMap<String, MappingRegistry>();
    @Autowired
    private RamRouteMapper ramRouteMapper;

    public void afterPropertiesSet() {
    }

    private void initMappingInfos() {
        List<Route> routes = this.ramRouteMapper.findAll();
        for (Route route : routes) {
            MappingRegistry mappingRegistry = this.getMappingRegistry(route.getApp());
            MappingInfo.Builder builder = MappingInfo.paths(route.getPath()).methods(MappingInfo.getMethod(route.getMethod()));
            mappingRegistry.register(builder.options(mappingRegistry.getConfig()).build(), new PatternVO(route));
        }
    }

    public MappingRegistry getMappingRegistry(String app) {
        if ("middleware".equals(app)) {
            return this.internalMappingRegistry;
        }
        if (!this.appMappingRegistries.containsKey(app)) {
            this.appMappingRegistries.put(app, new MappingRegistry());
        }
        return this.appMappingRegistries.get(app);
    }
}

