/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.mapper.RamPolicyRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamPolicyRouteCrudServiceImpl
implements RamPolicyRouteCrudService {
    @Autowired
    private RamPolicyRouteMapper ramPolicyRouteMapper;

    @Override
    public long insert(PolicyRoute data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramPolicyRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramPolicyRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(PolicyRoute data) {
        this.ramPolicyRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public PolicyRoute findBySid(long sid) {
        return this.ramPolicyRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(PolicyRoute data) {
        return this.ramPolicyRouteMapper.exists(data.getPolicySid(), data.getRouteSid());
    }

    @Override
    public int deleteByPolicySid(long policySid) {
        return this.ramPolicyRouteMapper.deleteByPolicySid(policySid);
    }

    @Override
    public List<PolicyVO> findByRouteSid(long policySid) {
        return this.ramPolicyRouteMapper.findByRouteSid(policySid);
    }

    @Override
    public List<RouteVO> findByPolicySid(long routeSid) {
        return this.ramPolicyRouteMapper.findByPolicySid(routeSid);
    }
}

