package com.digiwin.dap.middle.ram.domain.function;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Function {

    /**
     * 依次为userId、tenantId、sysId
     * 用::分割，所以各id不能有2个以上::，不然模糊匹配可能出问题
     */
    public static final String REDIS_PERMISSION_KEY = "iam:permission:all:%s::%s::%s";

    private FunctionQuery query;
    private FunctionResult result;

    public Function() {
        this.query = new FunctionQuery();
        this.result = new FunctionResult();
    }

    /**
     * 获取权限缓存，解析actionId和conditionId集合
     *
     * @param user 登录用户
     * @param sys  登录应用
     */
    public static List<String> obtainPolicyIds(AuthoredUser user, AuthoredSys sys) {
        return obtainPolicyIds(user.getUserId(), user.getTenantId(), sys.getId());
    }

    public static List<String> obtainPolicyIds(String userId, String tenantId, String sysId) {
        String key = String.format(Function.REDIS_PERMISSION_KEY, userId, tenantId, sysId);
        List<String> policyIds = new ArrayList<>();
        Function function = RedisUtils.get(key, Function.class);
        if (function == null || function.getResult() == null) {
            return policyIds;
        }
        // 添加应用
        String appId = function.getQuery().getTarget();
        policyIds.add(appId);
        // 添加模组
        List<String> moduleIds = function.getResult().getPermissions().stream().map(p -> appId + ":" + p.getModuleId()).distinct().collect(Collectors.toList());
        policyIds.addAll(moduleIds);

        for (FunctionPermission action : function.getResult().getPermissions()) {
            // 添加行为
            policyIds.add(action.getTarget());
            for (Map.Entry<String, Map<String, String>> condition : action.getConditions().entrySet()) {
                for (Map.Entry<String, String> conditionValue : condition.getValue().entrySet()) {
                    // 添加作业
                    policyIds.add(condition.getKey() + ":" + conditionValue.getValue());
                }
            }
        }
        return policyIds;
    }

    public FunctionQuery getQuery() {
        return query;
    }

    public void setQuery(FunctionQuery query) {
        this.query = query;
    }

    public FunctionResult getResult() {
        return result;
    }

    public void setResult(FunctionResult result) {
        this.result = result;
    }
}
