package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.entity.Grant;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamGrantMapper {

    int insert(@Param("entity") Grant entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Grant entity);

    Grant findBySid(@Param("sid") long sid);

    boolean exists(@Param("sid") long sid);

    Grant findByTypeAndTarget(@Param("type") String type, @Param("targetId") String targetId);

    long countByPage(@Param("cond") Grant cond, @Param("filter") Filter<?> filter);

    List<GrantVO> findByPage(@Param("cond") Grant cond, @Param("filter") Filter<?> filter);

    List<Grant> findByCond(@Param("cond") Grant cond);
}
