/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/route"})
@RestController
public class RamRouteController {
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Route body) {
        long routeSid = this.ramRouteCrudService.insert(body);
        this.ramCacheService.routeChange(body.getApp());
        return StdData.ok((Object)BaseSid.ok(routeSid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Route route = (Route)this.ramRouteCrudService.findBySid(body.getSid());
        if (route == null) {
            return StdData.ok((Object)BaseSid.ok(0L));
        }
        List<PolicyVO> routePolicies = this.ramPolicyRouteCrudService.findByRouteSid(body.getSid());
        if (!routePolicies.isEmpty()) {
            String grant = routePolicies.stream().map(PolicyVO::getId).collect(Collectors.joining(","));
            throw new BusinessException(String.format("\u8be5\u8def\u7531\u88ab\u7b56\u7565[%s]\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", grant));
        }
        this.ramRouteCrudService.deleteBySid(body.getSid());
        this.ramCacheService.routeChange(route.getApp());
        return StdData.ok((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Route route = (Route)this.ramRouteCrudService.findBySid(body.getSid());
        return StdData.ok((Object)route);
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody Route body) {
        return StdData.ok(this.ramRouteCrudService.findByCond(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody Page<Route> body) {
        body.setOrderBy("r.create_date desc");
        return StdData.ok(this.ramRouteCrudService.findByPage(body));
    }
}

