/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.authentication.handler;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

@Order(value=5)
public class NoAuthAuthCheckHandler
extends AuthCheckHandler {
    public NoAuthAuthCheckHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        MappingRegistry mappingRegistry = this.ramCoreService.getPattern(request.getAppId(), PolicyType.NoAuth.name());
        PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
        if (matched != null) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}

