package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.service.MappingRegistry;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Statement {

    private MappingRegistry deny;
    private MappingRegistry allow;

    public Statement() {
    }

    public Statement(List<PatternVO> routes, MappingRegistry mappingRegistry) {
        Map<Boolean, List<PatternVO>> map = routes.stream().collect(Collectors.groupingBy(PatternVO::getEffect));
        deny = new MappingRegistry(map.getOrDefault(Boolean.FALSE, Collections.emptyList()), mappingRegistry);
        allow = new MappingRegistry(map.getOrDefault(Boolean.TRUE, Collections.emptyList()), mappingRegistry);
    }

    public MappingRegistry getDeny() {
        return deny;
    }

    public MappingRegistry getAllow() {
        return allow;
    }
}
