package com.digiwin.dap.middle.ram.entity;

import com.digiwin.dap.middleware.commons.util.StrUtils;

import java.util.Objects;

/**
 * 路由清单
 *
 * @author fobgochod
 * @date 2021/8/16 15:57
 */
public class Route extends BaseEntity {

    private String app;
    private String name;
    private String method;
    private String path;
    private String tableName;
    private String remark;

    public String getApp() {
        return app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StrUtils.hasText(method)) {
            builder.append(method).append(" ");
        }
        builder.append(path);
        builder.append('}');
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Route route = (Route) o;
        return Objects.equals(method, route.method) && path.equals(route.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path);
    }
}
