package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.access.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 访问控制RAM（Resource Access Management）<br>
 * 管理用户身份与资源访问权限
 *
 * @author fobgochod
 * @date 2021/9/29 15:28
 * @see com.digiwin.dap.middle.ram.service.access.policy.BeforePolicyFilterHandler
 * @see com.digiwin.dap.middle.ram.service.access.policy.NonePolicyFilterHandler
 */
public class BeforeAuthenticationFilter extends OncePerRequestFilter implements Ordered {

    private final List<PolicyFilterHandler> policyHandlers;

    public BeforeAuthenticationFilter(List<PolicyFilterHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        final AppAuthContext context = AppAuthContextHolder.getContext();

        try {
            PolicyTypeChain policyTypeChain = new PolicyTypeChain(policyHandlers);
            ResultType result = policyTypeChain.doNextStep(context, context.getRequestInfo());
            context.setResultType(result.name());
        } catch (Exception e) {
            logger.error("RAM before authentication filter handler error", e);
        }

        if (ResultType.EXPLICIT_DENY.name().equals(context.getResultType())) {
            throw new UnauthorizedException(ResultType.EXPLICIT_DENY);
        }

        filterChain.doFilter(request, response);
    }

    @Override
    public int getOrder() {
        return FilterOrderEnum.BEFORE_SECURITY.order();
    }
}
