package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

import java.util.List;

/**
 * 功能权限，策略类型 {@link PolicyType#Function}
 * <p>
 * 用户拥有对应功能权限即拥有对应的API访问权限
 * <p>
 * 此类型下策略ID即作业(actionId)或状态ID(conditionId)
 *
 * @author fobgochod
 * @date 2021/9/18 21:04
 */
@Order(400)
public class FunctionPolicyFilterHandler extends PolicyFilterHandler {

    public FunctionPolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        AuthoredUser authoredUser = context.getAuthoredUser();
        AuthoredSys authoredSys = context.getAuthoredSys();
        if (authoredUser != null && authoredSys != null) {
            MappingRegistry mappingRegistry = ramCoreService.getPattern(request.getAppId());
            PatternVO pattern = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
            if (pattern != null) {
                List<String> actionIds = ramCoreService.findPolicyIdByRoute(request.getAppId(), PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
                boolean match = Function.obtainPolicyIds(authoredUser, authoredSys).stream().anyMatch(actionIds::contains);
                if (match) {
                    return ResultType.ALLOW;
                }
            }
        }
        return ResultType.IMPLICIT_DENY;
    }
}
