package com.digiwin.dap.middle.ram.service.authentication;

import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.WebUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;

import javax.servlet.http.HttpServletRequest;

/**
 * App授权检查
 *
 * @author fobgochod
 * @date 2022/4/11 14:57
 */
public abstract class AuthCheckHandler {

    protected RamCoreService ramCoreService;

    /**
     * 是否支持此 授权检查处理器
     *
     * @param authType 授权检查结果
     * @return 是否支持此
     */
    public boolean supports(AuthType authType) {
        return authType == null;
    }

    /**
     * 查询是否有应用授权
     *
     * @param authResult 授权信息
     * @param user       登录用户
     * @param sys        登录应用
     * @return 授权检查结果
     */
    public final AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        HttpServletRequest request = WebUtils.getRequest();
        return this.processAuth(authResult, user, sys, request == null ? RequestInfo.of() : RequestInfo.of(request));
    }

    /**
     * 查询是否有应用授权
     *
     * @param authResult 授权信息
     * @param user       登录用户
     * @param sys        登录应用
     * @param request    当前请求信息
     * @return 授权检查结果
     */
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        return authResult;
    }
}
