package com.digiwin.dap.middle.ram.service.authentication.handler;

import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import org.springframework.core.annotation.Order;

/**
 * 授权检查必要参数管控，缺少直接不做授权检查
 *
 * @author fobgochod
 * @date 2022/4/14 14:45
 */
@Order(0)
public class BeforeAuthCheckHandler extends AuthCheckHandler {

    public BeforeAuthCheckHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return true;
    }

    /**
     * 下列情况不用检查授权信息
     * 1. 没有用户
     * 2. 没有租户
     * 3. 集成账号
     * 4. 没有应用
     * 5. 内部应用
     *
     * @param authResult 授权信息
     * @param user       登录用户
     * @param sys        登录应用
     * @param request    当前请求信息
     */
    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        boolean notCheck = user == null || user.getTenantId() == null
                || GlobalConstants.INTEGRATION.equals(user.getUserId())
                || sys == null || sys.getId() == null || sys.isInside();
        if (notCheck) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}
