package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.entity.BaseEntity;

import java.util.Collections;
import java.util.List;

public interface RamBaseService<T extends BaseEntity> {

    /**
     * 新增数据
     *
     * @return 主键
     */
    long insert(T data);

    /**
     * 删除数据
     *
     * @param sid 主键
     * @return 删除成功数目 0或1
     */
    int deleteBySid(long sid);

    /**
     * 修改数据
     *
     * @return 主键
     */
    long update(T data);

    /**
     * 查询数据
     *
     * @param sid 主键
     */
    T findBySid(long sid);

    /**
     * 数据是否存在
     */
    boolean exists(T data);

    /**
     * 分页查询
     *
     * @param data 查询条件
     */
    default List<T> findByCond(T data) {
        return Collections.emptyList();
    }
}
