package com.digiwin.dap.middle.ram.util;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *  WebUtils.java
 *
 * @author fobgochod
 * @date 2023/7/19 18:20
 * @see WebApplicationContextUtils
 */
public class WebUtils {

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = currentRequestAttributes();
        if (attributes != null) {
            return attributes.getRequest();
        }
        return null;
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = currentRequestAttributes();
        if (attributes != null) {
            return attributes.getResponse();
        }
        return null;
    }

    /**
     * Return the current RequestAttributes instance as ServletRequestAttributes.
     *
     * @see RequestContextHolder#currentRequestAttributes()
     */
    private static ServletRequestAttributes currentRequestAttributes() {
        RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
        if (requestAttr instanceof ServletRequestAttributes) {
            return (ServletRequestAttributes) requestAttr;
        }
        return null;
    }
}
