/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/grant"})
@RestController
public class RamGrantController {
    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Grant body) {
        long sid = this.ramGrantCrudService.insert(body);
        return StdData.ok((Object)BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Grant grant = (Grant)this.ramGrantCrudService.findBySid(body.getSid());
        if (grant == null) {
            return StdData.ok((Object)BaseSid.ok(0L));
        }
        this.ramGrantCrudService.deleteBySid(body.getSid());
        this.ramGrantPolicyCrudService.deleteByGrantSid(body.getSid());
        this.ramCacheService.grantRemove(grant);
        return StdData.ok((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Grant grant = (Grant)this.ramGrantCrudService.findBySid(body.getSid());
        return StdData.ok((Object)grant);
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody Grant body) {
        return StdData.ok(this.ramGrantCrudService.findByCond(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody Page<Grant> body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ok(this.ramGrantCrudService.findByPage(body));
    }
}

