/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=400)
public class FunctionPolicyFilterHandler
extends PolicyFilterHandler {
    public FunctionPolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        AuthoredUser authoredUser = context.getAuthoredUser();
        AuthoredSys authoredSys = context.getAuthoredSys();
        if (authoredUser != null && authoredSys != null) {
            MappingRegistry mappingRegistry = this.ramCoreService.getPattern(request.getAppId());
            PatternVO pattern = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
            if (pattern != null) {
                List<String> actionIds = this.ramCoreService.findPolicyIdByRoute(request.getAppId(), PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
                boolean match = Function.obtainPolicyIds(authoredUser, authoredSys).stream().anyMatch(actionIds::contains);
                if (match) {
                    return ResultType.ALLOW;
                }
            }
        }
        return ResultType.IMPLICIT_DENY;
    }
}

