/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.executor.cache;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import java.util.List;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

@CacheConfig(cacheNames={"12h"}, cacheManager="dapCacheManager")
public class PolicyCachingExecutor
implements PolicyExecutor {
    private final PolicyExecutor delegate;

    public PolicyCachingExecutor(PolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':' + #policyType")
    public List<PatternVO> findRouteByPolicyType(String app, String policyType) {
        return this.delegate.findRouteByPolicyType(app, policyType);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':' + #policyId")
    public List<PatternVO> findRouteByPolicyId(String app, String policyId) {
        return this.delegate.findRouteByPolicyId(app, policyId);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':{' + #method + ' ' + #path + '}'")
    public List<PolicyVO> findPolicyIdByRoute(String app, String method, String path) {
        return this.delegate.findPolicyIdByRoute(app, method, path);
    }
}

