package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.mapper.RamPolicyRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyRouteCrudServiceImpl implements RamPolicyRouteCrudService {

    @Autowired
    private RamPolicyRouteMapper ramPolicyRouteMapper;

    @Override
    public long insert(PolicyRoute data) {
        BaseUtils.setCreateFields(data);
        ramPolicyRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(PolicyRoute data) {
        ramPolicyRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public PolicyRoute findBySid(long sid) {
        return ramPolicyRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(PolicyRoute data) {
        return ramPolicyRouteMapper.exists(data.getPolicySid(), data.getRouteSid());
    }

    public int deleteByPolicySid(long policySid) {
        return ramPolicyRouteMapper.deleteByPolicySid(policySid);
    }

    @Override
    public int deleteByPolicySidAndRouteSid(long policySid, long routeSid) {
        return ramPolicyRouteMapper.deleteByPolicySidAndRouteSid(policySid, routeSid);
    }

    public List<PolicyVO> findByRouteSid(long routeSid) {
        return ramPolicyRouteMapper.findByRouteSid(routeSid);
    }

    public List<RouteVO> findByPolicySid(long policySid) {
        return ramPolicyRouteMapper.findByPolicySid(policySid);
    }

    @Override
    public PageData<PolicyRouteVO> findByPage(PolicyRouteCond page) {
        long total = ramPolicyRouteMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<PolicyRouteVO> paths = ramPolicyRouteMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}
