package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.service.executor.RamGrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamPolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamRouteExecutor;
import com.digiwin.dap.middle.ram.support.MappingInfoRegistry;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class RamCoreServiceImpl implements RamCoreService {

    @Autowired
    private RamGrantExecutor ramGrantExecutor;
    @Autowired
    private RamRouteExecutor ramRouteExecutor;
    @Autowired
    private RamPolicyExecutor ramPolicyExecutor;
    @Autowired
    private RamExecutorMapper ramExecutorMapper;
    @Autowired
    private MappingInfoRegistry mappingInfoRegistry;

    @Override
    public MappingRegistry getPattern(String app) {
        List<PatternVO> patterns = ramRouteExecutor.findRouteByApp(app);
        return new MappingRegistry(patterns, mappingInfoRegistry.getMappingRegistry(app));
    }

    @Override
    public MappingRegistry getPattern(String app, String policyType) {
        List<PatternVO> patterns = ramPolicyExecutor.findRouteByPolicyType(app, policyType);
        return new MappingRegistry(patterns, mappingInfoRegistry.getMappingRegistry(app));
    }

    @Override
    public Statement getPolicyRoute(String app, List<String> policyIds) {
        List<PatternVO> routes = new ArrayList<>();
        for (String policyId : policyIds) {
            routes.addAll(ramPolicyExecutor.findRouteByPolicyId(app, policyId));
        }
        return new Statement(routes, mappingInfoRegistry.getMappingRegistry(app));
    }

    @Override
    public Statement getPolicyRoute(String app, String policyType, String targetType, String targetId) {
        List<PatternVO> routes = new ArrayList<>();
        List<String> policyIds = this.findPolicyId(app, policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(ramPolicyExecutor.findRouteByPolicyId(app, policyId));
        }
        return new Statement(routes, mappingInfoRegistry.getMappingRegistry(app));
    }

    @Override
    public List<String> findPolicyIdByRoute(String app, String policyType, String method, String path) {
        List<PolicyVO> policies = ramPolicyExecutor.findPolicyByPath(app, method, path);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findPolicyId(String app, String policyType, String targetType, String targetId) {
        List<PolicyVO> policies = ramGrantExecutor.findPolicyByTargetId(app, targetType, targetId);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findTargetIdByRoute(String app, String policyType, String targetType, String method, String path) {
        List<String> policyIds = this.findPolicyIdByRoute(app, policyType, method, path);
        List<String> targetIds = new ArrayList<>();
        for (String policyId : policyIds) {
            targetIds.addAll(findTargetByPolicyId(app, targetType, policyId));
        }
        return targetIds;
    }

    @Override
    public List<String> findTargetByPolicyId(String app, String targetType, String policyId) {
        List<GrantVO> grants = ramExecutorMapper.findGrantByPolicyId(app, targetType, policyId);
        return grants.stream().map(GrantVO::getTargetId).collect(Collectors.toList());
    }
}
