/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import com.digiwin.dap.middleware.constant.InternalUrl;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class RamV1AccessCheckFilter
extends OncePerRequestFilter
implements Ordered {
    private final PathPolicyHandler<AccessUser> pathPolicyHandler;
    private final AuthPolicyHandler authPolicyHandler;

    public RamV1AccessCheckFilter(PathPolicyHandler<AccessUser> pathPolicyHandler, AuthPolicyHandler authPolicyHandler) {
        this.pathPolicyHandler = pathPolicyHandler;
        this.authPolicyHandler = authPolicyHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        AppAuthContext context = AppAuthContextHolder.getContext();
        RequestInfo requestInfo = context.getRequestInfo();
        if (InternalUrl.tokenAnalyzes().containsKey(requestURI)) {
            this.accessCheck(context, requestInfo);
        } else if (!InternalUrl.authAllows().containsKey(requestURI) && !context.isUpstream()) {
            this.accessCheck(context, requestInfo);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void accessCheck(AppAuthContext context, RequestInfo requestInfo) {
        AccessUser requestUser = AccessUser.of(requestInfo.getAppId(), requestInfo.getMethod(), requestInfo.getPath());
        AccessResult accessResult = this.pathPolicyHandler.handle(requestUser);
        context.setResultType(accessResult.getResultType().name());
        accessResult.checkAccessResult();
        AuthResult authResult = this.authPolicyHandler.process(AuthResult.of(), requestUser);
        AuthType.checkAuthResult((AuthType)authResult.getAuthType(), (String)requestUser.getUserId(), (String)requestUser.getTenantId(), (String)requestUser.getSysId());
    }

    public int getOrder() {
        return FilterOrderEnum.ACCESS_CHECK.order();
    }
}

