/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middle.ram.domain.remote.Function;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultRamHandlerSupport
implements RamHandlerSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRamHandlerSupport.class);
    private static final String USER_WHITE_LIST = "integration;virtual";
    @Autowired
    private DapEnv dapEnv;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate retryRestTemplate;

    @Override
    public AuthResult getAuthResult(AuthResult authResult, AccessUser request) {
        AppAuthResult result = this.getAuthResult(request.getTenantId(), request.getUserId(), request.getSysId(), request.isPlatform(), authResult.getTenants(), !USER_WHITE_LIST.contains(request.getUserId()));
        return result.flushAuthType();
    }

    @Override
    public List<String> getUserFunction(AccessUser request) {
        return this.getUserFunction(request.getUserId(), request.getTenantId(), request.getSysId(), request.getUserToken()).uris(request.getSysId());
    }

    private AppAuthResult getAuthResult(String tenantId, String userId, String appId, boolean platform, List<String> tenants, boolean checkUserAuth) {
        String url = this.dapEnv.getCacUri() + "/api/cac/v4/authorizations/tenant/user/goods/check";
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("goodsCode", appId);
            body.put("tenants", tenants);
            body.put("checkUserAuth", Boolean.toString(checkUserAuth));
            if (platform) {
                body.put("apps", this.getAppIds(appId, true));
            } else {
                body.put("platformApps", this.getAppIds(appId, false));
            }
            HttpEntity httpEntity = new HttpEntity(body);
            return (AppAuthResult)((Object)this.retryRestTemplate.postForObject(url, (Object)httpEntity, AppAuthResult.class, new Object[0]));
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u83b7\u53d6\u7528\u6237\u5e94\u7528\u6388\u6743", (String)url, body, (Exception)e), (Throwable)e);
            throw new UnauthorizedException((ErrorHandler)RamI18nError.CAC_AUTH_GET_FAIL, (Object[])new String[]{tenantId, userId, appId}, 411005);
        }
    }

    private List<String> getAppIds(String appId, boolean platform) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("id", appId);
            requestBody.put("platform", platform);
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            String uri = this.dapEnv.getIamUri() + "/api/iam/v2/sys/platform/ids";
            ResponseEntity result = this.retryRestTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<String>>>(){}, new Object[0]);
            return (List)((StdData)result.getBody()).getData();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Function getUserFunction(String userId, String tenantId, String sysId, String userToken) {
        String uri = this.dapEnv.getIamUri() + "/api/iam/v2/permission/user/all";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> body = new HashMap<String, String>(3);
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("target", "drn:iam:app:" + sysId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            return (Function)this.retryRestTemplate.postForObject(uri, (Object)request, Function.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u529f\u80fd\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }
}

