package com.digiwin.dap.middle.ram.support.cache;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class CachePurgePublisherService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 业务数据发生变更，发布清除对应缓存消息
     *
     * @param cacheType 本地缓存类型
     * @param cacheKey  redis key
     */
    public void publishCacheEvict(String cacheKey, LocalCacheType cacheType) {
        String message = cacheType + RamConstant.MESSAGE_DELIMITER + cacheKey;
        stringRedisTemplate.convertAndSend(RamConstant.CACHE_PURGE_TOPIC, message);
    }
}