/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantCond;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamGrantCrudServiceImpl
implements RamGrantCrudService {
    @Autowired
    private RamGrantMapper ramGrantMapper;

    @Override
    public long insert(Grant data) {
        BaseUtils.setCreateFields(data);
        this.ramGrantMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramGrantMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setModifyFields(data);
        this.ramGrantMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return this.ramGrantMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Grant data) {
        return this.ramGrantMapper.exists(data.getSid());
    }

    @Override
    public List<GrantVO> findByCond(GrantCond cond) {
        return this.ramGrantMapper.findByCond(cond);
    }

    @Override
    public PageData<GrantVO> findByPage(GrantCond page) {
        long total = this.ramGrantMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<GrantVO> paths = this.ramGrantMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}

