package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.domain.BaseSid;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 策略信息
 *
 * @author fobgochod
 */
@RequestMapping("/api/ram/v2/policy")
@RestController
public class RamPolicyController {

    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Policy body) {
        long sid = ramPolicyCrudService.insert(body);
        return StdData.ok(BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Policy policy = ramPolicyCrudService.findBySid(body.getSid());
        if (policy == null) {
            return StdData.ok(BaseSid.ok(0));
        }
        List<GrantVO> policyGrants = ramGrantPolicyCrudService.findByPolicySid(body.getSid());
        if (!policyGrants.isEmpty()) {
            String grant = policyGrants.stream().map(o -> o.getType() + "-" + o.getTargetId()).collect(Collectors.joining(","));
            throw new BusinessException(String.format("该策略存在授权信息[%s]，不允许删除", grant));
        }
        ramPolicyCrudService.deleteBySid(body.getSid());
        ramPolicyRouteCrudService.deleteByPolicySid(body.getSid());
        ramCacheService.policyRemove(policy);
        return StdData.ok(BaseSid.ok(body.getSid()));

    }

    @PostMapping("/mod")
    public StdData<?> mod(@RequestBody Policy body) {
        Policy policy = ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            policy.setName(body.getName());
            ramPolicyCrudService.update(policy);
        }
        return StdData.ok(policy);
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = ramPolicyCrudService.findBySid(body.getSid());
        return StdData.ok(path);
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody PolicyCond body) {
        return StdData.ok(ramPolicyCrudService.findByCond(body));
    }

    @PostMapping("/search")
    public StdData<?> search(@RequestBody PolicyCond body) {
        return StdData.ok(ramPolicyCrudService.findByPage(body));
    }
}
