package com.digiwin.dap.middle.ram.domain.request;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middleware.exception.UnauthorizedException;

public class AccessResult {

    /**
     * 生效策略
     */
    private String policyId;
    /**
     * 判断结果
     */
    private ResultType resultType;

    public AccessResult() {
    }

    public AccessResult(ResultType resultType) {
        this.resultType = resultType;
    }

    public static AccessResult allow() {
        return new AccessResult(ResultType.ALLOW);
    }

    public static AccessResult deny(String policyId) {
        AccessResult accessResult = new AccessResult(ResultType.EXPLICIT_DENY);
        accessResult.setPolicyId(policyId);
        return accessResult;
    }

    public static AccessResult next() {
        return new AccessResult(ResultType.IMPLICIT_DENY);
    }

    public void checkAccessResult() {
        if (this.resultType == ResultType.EXPLICIT_DENY) {
            throw new UnauthorizedException(ResultType.EXPLICIT_DENY, String.format("实际生效策略(%s)", this.policyId));
        }
    }

    public String getPolicyId() {
        return policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public ResultType getResultType() {
        return resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }
}
