package com.digiwin.dap.middle.ram.support.cache;

import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middleware.cache.RedisUtils;

import java.util.List;

/**
 * 鉴权相关的业务缓存
 */
public class BusinessCache {

    /**
     * 授权缓存:tenantId:userId:sysId
     */
    private static final String TENANT_USER_SYS_AUTH = "cac:tenant:user:auth:%s::%s::%s";
    /**
     * 平台的应用缓存 平台ID
     */
    private static final String PLATFORM_SYS = "entity:sysonplatform:platform:";
    /**
     * 应用的平台缓存 应用ID
     */
    private static final String SYS_PLATFORM = "entity:sysonplatform:sys:";

    public static List<String> getAppIds(String appId, boolean platform) {
        if (platform) {
            // 是平台，则查询平台的应用
            return RedisUtils.get(PLATFORM_SYS + appId, List.class);
        } else {
            // 是应用，则查询应用的平台
            return RedisUtils.get(SYS_PLATFORM + appId, List.class);
        }
    }

    public static AppAuthResult getAuthResult(String tenantId, String userId, String appId) {
        String cacAuthKey = String.format(TENANT_USER_SYS_AUTH, tenantId, userId, appId);
        return RedisUtils.get(cacAuthKey, AppAuthResult.class);
    }
}
