package com.digiwin.dap.middle.ram.support.security.path;

import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.PolicyChain;
import com.digiwin.dap.middle.ram.support.security.SecurityHandler;
import com.digiwin.dap.middle.ram.support.security.path.handler.AllowListPathPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.handler.BasePathPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.handler.BeforePathPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.handler.FunctionPathPolicyHandler;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import java.util.ArrayList;
import java.util.List;

/**
 * PathPolicyHandlerComposite
 *
 * @author fobgochod
 * @see BeforePathPolicyHandler
 * @see AllowListPathPolicyHandler
 * @see BasePathPolicyHandler
 * @see FunctionPathPolicyHandler
 */
public class PathPolicyHandlerComposite extends PathPolicyHandler<AccessUser> {

    private final List<SecurityHandler<AccessUser>> handlers = new ArrayList<>(4);

    public PathPolicyHandlerComposite(RamCoreService baseService, RamHandlerSupport ramHandlerSupport, boolean function) {
        this.handlers.add(new BeforePathPolicyHandler());
        this.handlers.add(new AllowListPathPolicyHandler(baseService));
        this.handlers.add(new BasePathPolicyHandler(baseService));
        if (function) {
            this.handlers.add(new FunctionPathPolicyHandler(baseService, ramHandlerSupport));
        }
        AnnotationAwareOrderComparator.sort(this.handlers);
    }

    @Override
    public AccessResult handle(AccessUser request) {
        PolicyChain<AccessUser> chain = new PolicyChain<>(this.handlers);
        return chain.doNextStep(request);
    }
}