/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.GrantPolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantPolicyCond;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamGrantPolicyCrudServiceImpl
implements RamGrantPolicyCrudService {
    @Autowired
    private RamGrantPolicyMapper ramGrantPolicyMapper;

    @Override
    public long insert(GrantPolicy data) {
        BaseUtils.setCreateFields(data);
        this.ramGrantPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramGrantPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(GrantPolicy data) {
        this.ramGrantPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public GrantPolicy findBySid(long sid) {
        return this.ramGrantPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(GrantPolicy data) {
        return this.ramGrantPolicyMapper.exists(data.getGrantSid(), data.getPolicySid());
    }

    @Override
    public int deleteByGrantSid(long grantSid) {
        return this.ramGrantPolicyMapper.deleteByGrantSid(grantSid);
    }

    @Override
    public List<GrantVO> findByPolicySid(long policySid) {
        return this.ramGrantPolicyMapper.findByPolicySid(policySid);
    }

    @Override
    public List<PolicyVO> findByGrantSid(long grantSid) {
        return this.ramGrantPolicyMapper.findByGrantSid(grantSid);
    }

    @Override
    public PageData<GrantPolicyVO> findByPage(GrantPolicyCond page) {
        long total = this.ramGrantPolicyMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<GrantPolicyVO> paths = this.ramGrantPolicyMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}

