package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamPolicyRouteMapper {

    int insert(@Param("entity") PolicyRoute entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") PolicyRoute entity);

    PolicyRoute findBySid(@Param("sid") long sid);

    boolean exists(@Param("policySid") long policySid, @Param("routeSid") long routeSid);

    int deleteByPolicySid(@Param("policySid") long policySid);

    int deleteByPolicySidAndRouteSid(@Param("policySid") long policySid, @Param("routeSid") long routeSid);

    List<PolicyVO> findByRouteSid(@Param("routeSid") long routeSid);

    List<RouteVO> findByPolicySid(@Param("policySid") long policySid);

    long countByPage(@Param("cond") PolicyRouteCond cond);

    List<PolicyRouteVO> findByPage(@Param("cond") PolicyRouteCond cond, @Param("pageable") Pageable pageable);
}
