package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;

import java.util.List;

public interface RamPolicyExecutor {

    /**
     * 根据策略ID获取路由配置信息
     *
     * @param app      应用ID
     * @param policyId 策略ID
     */
    List<PatternVO> findRouteByPolicyId(String app, String policyId);

    /**
     * 获取特定策略类型下的路由配置信息
     *
     * @param app        应用ID
     * @param policyType {@link PolicyType#AllowList} {@link PolicyType#Function}
     */
    List<PatternVO> findRouteByPolicyType(String app, String policyType);

    /**
     * 查询绑定指定路由的策略信息
     * <p>
     * {@link PolicyType#AcrossTenant} {@link PolicyType#Function}
     *
     * @param app    应用ID
     * @param method 方法
     * @param path   路由
     * @return 策略ID
     */
    List<PolicyVO> findPolicyByPath(String app, String method, String path);
}

