package com.digiwin.dap.middle.ram.service.executor.simple;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.executor.RamPolicyExecutor;

import java.util.List;

public class RamPolicySimpleExecutor implements RamPolicyExecutor {

    private final RamExecutorMapper ramExecutorMapper;

    public RamPolicySimpleExecutor(RamExecutorMapper ramExecutorMapper) {
        this.ramExecutorMapper = ramExecutorMapper;
    }

    @Override
    public List<PatternVO> findRouteByPolicyId(String app, String policyId) {
        return ramExecutorMapper.findRouteByPolicyId(app, policyId);
    }

    @Override
    public List<PatternVO> findRouteByPolicyType(String app, String policyType) {
        return ramExecutorMapper.findRouteByPolicyType(app, policyType);
    }

    @Override
    public List<PolicyVO> findPolicyByPath(String app, String method, String path) {
        return ramExecutorMapper.findPolicyByPath(app, method, path);
    }
}

