package com.digiwin.dap.middle.ram.support.security;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 按照顺序执行 {@link TargetType}
 *
 * @author fobgochod
 */
public final class TargetChain<T extends AccessInfo> {

    private static final Logger logger = LoggerFactory.getLogger(TargetChain.class);

    private final List<TargetInfo> targets;
    private final int size;
    private final TargetHandler<T> handler;
    private int currentPosition = 0;

    public TargetChain(TargetHandler<T> handler, List<TargetInfo> targets) {
        this.handler = handler;
        this.targets = targets;
        this.size = targets.size();
    }

    public AccessResult doNextStep(T request) {
        if (currentPosition == size) {
            return AccessResult.next();
        } else {
            currentPosition++;
            TargetInfo next = targets.get(currentPosition - 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking {} {} ({}/{})", request.getId(), next.toString(), this.currentPosition, this.size);
            }
            AccessResult result = handler.handle(next.getTargetType(), next.getTargetId(), request);
            if (ResultType.IMPLICIT_DENY == result.getResultType()) {
                return doNextStep(request);
            } else {
                return result;
            }
        }
    }
}