package com.digiwin.dap.middle.ram.support.security.auth.handler;

import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import org.springframework.core.annotation.Order;

/**
 * 授权检查必要参数管控，缺少直接不做授权检查
 *
 * @author fobgochod
 */
@Order(0)
public class BeforeAuthPolicyHandler extends AuthPolicyHandler {

    public BeforeAuthPolicyHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return true;
    }

    /**
     * 下列情况不用检查授权信息
     * 1. 没有用户
     * 2. 没有租户
     * 3. 集成账号
     * 4. 没有应用
     * 5. 内部应用
     *
     * @param authResult 授权信息
     * @param request    当前请求信息
     */
    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        boolean notCheck = request.getUserId() == null || request.getTenantId() == null
                || GlobalConstants.INTEGRATION.equals(request.getUserId())
                || request.getSysId() == null || request.isInside();
        if (notCheck) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}
