/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.support.security.SecurityHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolicyChain<T extends AccessInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PolicyChain.class);
    private final List<? extends SecurityHandler<T>> handlers;
    private final int size;
    private int currentPosition = 0;

    public PolicyChain(List<? extends SecurityHandler<T>> handlers) {
        this.handlers = new ArrayList<SecurityHandler<T>>(handlers);
        this.size = handlers.size();
    }

    public AccessResult doNextStep(T request) {
        AccessResult result;
        if (this.currentPosition == this.size) {
            return AccessResult.next();
        }
        ++this.currentPosition;
        SecurityHandler<T> next = this.handlers.get(this.currentPosition - 1);
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking {} {} ({}/{})", new Object[]{((AccessInfo)request).getId(), next.getClass().getSimpleName(), this.currentPosition, this.size});
        }
        if (ResultType.IMPLICIT_DENY == (result = next.handle(request)).getResultType()) {
            return this.doNextStep(request);
        }
        return result;
    }
}

