/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.domain.RamVersion;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import com.digiwin.dap.middleware.constant.InternalUrl;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class RamV1AccessCheckFilter
extends OncePerRequestFilter
implements Ordered {
    private final PathPolicyHandler<AccessUser> pathPolicyHandler;
    private final AuthPolicyHandler authPolicyHandler;

    public RamV1AccessCheckFilter(PathPolicyHandler<AccessUser> pathPolicyHandler, AuthPolicyHandler authPolicyHandler) {
        this.pathPolicyHandler = pathPolicyHandler;
        this.authPolicyHandler = authPolicyHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        AppAuthContext context = AppAuthContextHolder.getContext();
        RequestInfo requestInfo = context.getRequestInfo();
        if (InternalUrl.token().contains(requestURI)) {
            RamVersion version = RamVersion.of((String)request.getParameter("ramVersion"));
            if (version == RamVersion.v1) {
                this.ramCheckV1(context, requestInfo);
            }
        } else if (!(context.isInternal() || InternalUrl.auth().contains(requestURI) || InternalUrl.login().contains(requestURI))) {
            this.ramCheckV1(context, requestInfo);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void ramCheckV1(AppAuthContext context, RequestInfo requestInfo) {
        AccessUser requestUser = AccessUser.of(requestInfo.getAppId(), requestInfo.getMethod(), requestInfo.getPath());
        AccessResult accessResult = this.pathPolicyHandler.handle(requestUser);
        accessResult.checkAccessResult();
        context.setResultType(accessResult.getResultType().name());
        this.authPolicyHandler.handle(requestUser);
    }

    public int getOrder() {
        return FilterOrderEnum.ACCESS_CHECK.order();
    }
}

