/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.service.core.RamCachePurgeService;
import com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder;
import com.digiwin.dap.middle.ram.support.cache.CachePurgePublisherService;
import com.digiwin.dap.middle.ram.support.cache.LocalCacheType;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.DapEnv;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamCachePurgeServiceImpl
implements RamCachePurgeService {
    @Autowired
    private DapEnv dapEnv;
    @Autowired(required=false)
    private CachePurgePublisherService cachePurgePublisherService;

    private void delete(String cacheKey, LocalCacheType cacheType) {
        RedisUtils.delete((String)cacheKey);
        if (this.dapEnv.isRamCache()) {
            this.cachePurgePublisherService.publishCacheEvict(cacheKey, cacheType);
        }
    }

    @Override
    public void deletePolicyByTargetId(String app, String targetType, String targetId) {
        String key = CacheKeyBuilder.getPolicyByTargetId(this.dapEnv.getAppName(), app, targetType, targetId);
        this.delete(key, LocalCacheType.POLICY_BY_TARGET_ID);
    }

    @Override
    public void deleteRouteByPolicyId(String app, String policyId) {
        String key = CacheKeyBuilder.getRouteByPolicyId(this.dapEnv.getAppName(), app, policyId);
        this.delete(key, LocalCacheType.ROUTE_BY_POLICY_ID);
    }

    @Override
    public void deleteRouteByPolicyType(String app, String policyType) {
        String key = CacheKeyBuilder.getRouteByPolicyType(this.dapEnv.getAppName(), app, policyType);
        this.delete(key, LocalCacheType.ROUTE_BY_POLICY_TYPE);
    }

    @Override
    public void deletePolicyByPath(String app, String method, String path) {
        String key = CacheKeyBuilder.getPolicyByPath(this.dapEnv.getAppName(), app, method, path);
        this.delete(key, LocalCacheType.POLICY_BY_PATH);
    }

    @Override
    public void deleteRouteByApp(String app) {
        String key = CacheKeyBuilder.getRouteByApp(this.dapEnv.getAppName(), app);
        this.delete(key, LocalCacheType.ROUTE_BY_APP);
    }
}

