package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.entity.BaseEntity;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;

import java.time.LocalDateTime;

/**
 * 基础字段填充
 *
 * @author fobgochod
 */
public final class BaseUtils {

    public static void setCreateFields(BaseEntity entity) {
        if (entity.getSid() == null) {
            entity.setSid(SnowFlake.getInstance().newId());
        }
        entity.setCreateBy(UserUtils.getUserSid());
        entity.setCreateById(UserUtils.getUserName());
        entity.setCreateDate(LocalDateTime.now());
        setModifyFields(entity);
    }

    public static void setModifyFields(BaseEntity entity) {
        entity.setModifyBy(UserUtils.getUserSid());
        entity.setModifyById(UserUtils.getUserName());
        entity.setModifyDate(LocalDateTime.now());
    }
}
