package com.digiwin.dap.middle.ram.constant;

import com.digiwin.dap.middle.ram.support.RamMessageSource;
import com.digiwin.dap.middleware.domain.ErrorHandler;

/**
 * 统一错误码
 *
 * @author fobgochod
 */
public enum RamI18nError implements ErrorHandler {


    CYBER_SECURITY("1S201", "dap.middleware.ram.access.implicit"),
    CAC_AUTH_GET_FAIL("21009", "cac.auth.get.fail");

    private final String errorCode;
    private final String code;

    RamI18nError(String errorCode, String code) {
        this.errorCode = errorCode;
        this.code = code;
    }

    public static boolean containsCode(String code) {
        for (RamI18nError value : RamI18nError.values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getErrorMessage() {
        return RamMessageSource.getAccessor().getMessage(code);
    }
}
